clear all

* Set folder

cd ..\Outputs

use SEMESTER, clear

gen IMF  = GPIMFtp0gtm0*100
gen OECD = GPOECtp0gtm0*100
label var IMF IMF
label var OECD OECD
rename GYCOCtp6gtm0 CONSENSUS
corr IMF OECD CONSENSUS

gen flag1=1
replace flag1=0 if ISO=="SVK" & year==2009 & semester==1
replace flag1=0 if ISO=="SVK" & year==2009 & semester==2

gen txt0=""
replace txt0="SVK, 2009S2"  if ISO=="SVK" & year==2009 & semester==1
replace txt0="SVK, 2009S1"  if ISO=="SVK" & year==2009 & semester==2

twoway (scatter IMF OECD if IMF!=. & OECD!=. & flag1==1, msymbol(oh) mcolor(black) mlwidth(thin)) ///
	   (scatter IMF OECD if IMF!=. & OECD!=. & flag1==0, msymbol(oh) mcolor(black) mlwidth(thin) mlabel(txt0) mlabcolor(black) mlabposition(6)) ///
	   (lfit IMF OECD if IMF!=. & OECD!=., lcolor(red)) ///
	   , legend(off) ///
	   xtitle("Growth rate of potential output (annualized %), OECD") ///
	   ytitle("Growth rate of potential output (annualized %), IMF") ///
		graphregion(color(white)) bgcolor(white)

capture drop flag2
gen flag2=1
replace flag2=0 if ISO=="ESP" & year>=2009
replace flag2=2 if ISO=="ESP" & year==2010 & semester==1

twoway (scatter OECD CONSENSUS  if CONSENSUS~=. & OECD!=. & flag2==1, msymbol(oh) mcolor(black) mlwidth(thin)) ///
	   (scatter OECD CONSENSUS  if CONSENSUS!=. & OECD!=. & flag2==0, msymbol(o) mfcolor(black) mcolor(black) mlwidth(thin) mlabel(txt0) mlabcolor(black) mlabposition(6)) ///
	   (scatter OECD CONSENSUS  if CONSENSUS!=. & OECD!=. & flag2==2, msymbol(o) mfcolor(black) mcolor(black) mlwidth(thin) mlabel(txt0) mlabcolor(black) mlabposition(6) mlabel(ISO)) ///	   
	   (lfit OECD CONSENSUS  if CONSENSUS!=. & OECD!=., lcolor(red)) ///
	   , legend(off) ///
	   ylabel(-1(1)5) ///
	   ytitle("Growth rate of potential output (annualized %), OECD") ///
	   xtitle("Growth rate of actual output, 6-10 yr ahead (annualized %), Consensus Economics") ///
		graphregion(color(white)) bgcolor(white)
		
capture drop flag2
gen flag2=1
replace flag2=0 if ISO=="ESP" & year>=2009
replace flag2=2 if ISO=="ESP" & year==2012 & semester==2
	
twoway (scatter IMF CONSENSUS  if CONSENSUS~=. & IMF!=. & flag2==1, msymbol(oh) mcolor(black) mlwidth(thin)) ///
	   (scatter IMF CONSENSUS  if CONSENSUS!=. & IMF!=. & flag2==0, msymbol(o) mfcolor(black) mcolor(black) mlwidth(thin) mlabel(txt0) mlabcolor(black) mlabposition(6)) ///
	   (scatter IMF CONSENSUS  if CONSENSUS!=. & IMF!=. & flag2==2, msymbol(o) mfcolor(black) mcolor(black) mlwidth(thin) mlabel(txt0) mlabcolor(black) mlabposition(12) mlabel(ISO)) ///	  
	   (lfit IMF CONSENSUS  if CONSENSUS!=. & IMF!=., lcolor(red)) ///
	   , legend(off) ///
	   ytitle("Growth rate of potential output (annualized %), IMF") ///
	   xtitle("Growth rate of actual output, 6-10 yr ahead (annualized %), Consensus Economics") ///
		graphregion(color(white)) bgcolor(white)
		
reg IMF OECD, robust
reg IMF OECD if flag1==1, robust
xtreg IMF OECD i.tt, fe vce(robust)

local country="USA"

twoway ///
	(line IMF year  if IMF!=. & OECD!=. & semester==1 & ISO=="`country'", lcolor(red) lpattern(dash) lwidth(thick))  ///
	(line OECD year if IMF!=. & OECD!=. & semester==1 & ISO=="`country'", lcolor(blue)) ///
	(line CONSENSUS year if IMF!=. & OECD!=. & semester==1 & ISO=="`country'", lcolor(green)), ///
	xtitle("") xlabel(2005(1)2016) ///
	ytitle("Growth rate of potential output (annualized %)") ///
	legend(	label(1 "IMF") label(2 "OECD") label(3 "Consensus Economics") ///
			label(10 "Actual") ring(0) position(1) rows(1)) ///
	graphregion(color(white)) bgcolor(white)
	
foreach var in IMF OECD CONSENSUS {
	winsor `var', gen(`var'w) p(0.02)
}
	
summ IMF OECD CONSENSUS
corr IMF OECD CONSENSUS

summ IMFw OECDw CONSENSUSw
pwcorr IMFw OECDw CONSENSUSw, casewise
